<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Skill extends Model 
{

    protected $table = 'skills';
    public $timestamps = true;
    protected $fillable = array('name', 'image', 'category_id');

    public function category()
    {
        return $this->belongsTo('App\Models\Category');
    }

    public function projects()
    {
        return $this->belongsToMany('App\Models\Project', 'skill_project');
    }

    public function users()
    {
        return $this->belongsToMany('App\Models\User', 'skill_user');
    }

}